--> pralable
-- USE BD_Air_France;

CREATE VIEW V_TVA
AS
SELECT T.TVA_ID, TVA_CODE, TVT_DATE_APPLICATION AS DATE_DEBUT,
       COALESCE(DATEADD(day, -1, LEAD(TVT_DATE_APPLICATION) OVER(PARTITION BY TVA_CODE 
                                                                 ORDER BY TVT_DATE_APPLICATION)), TVA_OBSOLETE, '9999-12-31') AS DATE_FIN,
       TVT_TAUX
FROM   T_TVA AS T
       INNER JOIN T_TVA_TAUX_TVT AS TD
             ON T.TVA_ID = TD.TVA_ID;
             
--> ATTENTION : LEAD est une fonction de fentrage disponible qu' partir de la version 2012. Sans cette fonction, la requte peut tre crite sous la forme :

CREATE VIEW V_TVA
AS
SELECT T.TVA_ID, TVA_CODE, TVT_DATE_APPLICATION AS DATE_DEBUT,
       COALESCE(DATEADD(day, -1, (SELECT MIN(TVT_DATE_APPLICATION) 
                                  FROM   T_TVA_TAUX_TVT AS T2 
                                         INNER JOIN T_TVA AS T1 
                                               ON T1.TVA_ID = T2.TVA_ID 
                                  WHERE  T.TVA_CODE = T1.TVA_CODE 
                                    AND  TD.TVT_DATE_APPLICATION < T2.TVT_DATE_APPLICATION)) , '9999-12-31') AS DATE_FIN,
       TVT_TAUX
FROM   T_TVA AS T
       INNER JOIN T_TVA_TAUX_TVT AS TD
             ON T.TVA_ID = TD.TVA_ID;

--> NOTA : on voit immdiatement l'intrt d'une fonction comme LEAD (ou LAG)  la fois sur l'criture de la requte et les performances  

